clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

capture log close
log using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\log_files\log_step2141.log, replace
			
use wf_step1011.dta, clear
gen nuts_original=nuts
gen flag_1970=1
gen year_US=.
gen impute_all=-1
append using wf_step1031


*** Population weights
egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
gen pop_wgt =  age_total/sum_age_total

egen pop_wgt0=mean(pop_wgt), by(nuts_original) 

gen keep_flag=0
replace keep_flag=1 if smpl2==1
replace keep_flag=1 if year~=1971 & country=="US"
keep if keep_flag==1

collapse (mean) turnmig_rate share_age_0_24 share_age_55plus turnmig_rate_cps [aw=pop_wgt0], by(country year) 

replace year=1970 if year==1971
collapse (mean) turnmig_rate share_age_0_24 share_age_55plus turnmig_rate_cps, by(country year) 

drop if year==.
egen cid=group(country)
tsset cid year


tsfill, full


foreach var in country turnmig_rate share_age_0_24 share_age_55plus turnmig_rate_cps {
	capture replace `var'=`var'[_n-1] if cid==cid[_n-1] & `var'==.
	capture replace `var'=`var'[_n-1] if cid==cid[_n-1] & `var'==""
}

cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"
twoway (line turnmig_rate year if country=="US" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2005| year==2010) , lcolor(black) lwidth(vthick)) ///
	   (line turnmig_rate year if country=="UK" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), lcolor(red) lpattern(longdash)) ///
	   (line turnmig_rate year if country=="FR" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), lcolor(blue) lpattern(dash)) ///
	   (line turnmig_rate year if country=="IT" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), lcolor(green) lpattern(shortdash)) ///
	   (scatter turnmig_rate year if country=="SE" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), connect(direct) msymbol(O) mfcolor(white) mcolor(red) lcolor(red) lpattern(solid) ) ///	  
	   (scatter turnmig_rate year if country=="DE" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), connect(direct) msymbol(S) mfcolor(blue) mcolor(blue) lcolor(blue) lpattern(solid) ) ///	      
	   (scatter turnmig_rate year if country=="ES" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), connect(direct) msymbol(D) mfcolor(magenta) mcolor(magenta) lcolor(magenta) lpattern(solid) ) ///
	   (scatter turnmig_rate_cps year if country=="US", connect(direct) msymbol(O) mfcolor(black) mcolor(white) lcolor(black) lpattern(dash) ) ///
		,  ///
	xtitle("") ytitle("") subtitle("Panel A: Turnover mobility rate") ylabel(0.5(0.5)3) ///
	legend(off) ///
	saving(fig1.gph, replace)
	
	
twoway (line share_age_0_24 year if country=="US" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2005| year==2010), lcolor(black) lwidth(vthick)) ///
	   (line share_age_0_24 year if country=="UK" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), lcolor(red) lpattern(longdash)) ///
	   (line share_age_0_24 year if country=="FR" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), lcolor(blue) lpattern(dash)) ///
	   (line share_age_0_24 year if country=="IT" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), lcolor(green) lpattern(shortdash)) ///
	   (scatter share_age_0_24 year if country=="SE" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), connect(direct) msymbol(O) mfcolor(white) mcolor(red) lcolor(red) lpattern(solid) ) ///	  
	   (scatter share_age_0_24 year if country=="DE" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), connect(direct) msymbol(S) mfcolor(blue) mcolor(blue) lcolor(blue) lpattern(solid) ) ///	      
	   (scatter share_age_0_24 year if country=="ES" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), connect(direct) msymbol(D) mfcolor(magenta) mcolor(magenta) lcolor(magenta) lpattern(solid) ) ///		   
		,  ///
	xtitle("") ytitle("") subtitle("Panel B: Share of population aged 24 or less") ylabel(32(4)48)  ///
	legend(off) ///
	saving(fig2.gph, replace)
	
	
	
twoway (line share_age_55plus year if country=="US" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2005| year==2010), lcolor(black) lwidth(vthick)) ///
	   (line share_age_55plus year if country=="UK" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), lcolor(red) lpattern(longdash)) ///
	   (line share_age_55plus year if country=="FR" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), lcolor(blue) lpattern(dash)) ///
	   (line share_age_55plus year if country=="IT" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), lcolor(green) lpattern(shortdash)) ///
	   (scatter share_age_55plus year if country=="SE" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), connect(direct) msymbol(O) mfcolor(white) mcolor(red) lcolor(red) lpattern(solid) ) ///	  
	   (scatter share_age_55plus year if country=="DE" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), connect(direct) msymbol(S) mfcolor(blue) mcolor(blue) lcolor(blue) lpattern(solid) ) ///	      
	   (scatter share_age_55plus year if country=="ES" & (year==1970 | year==1980 | year==1990 | year==2000 | year==2010), connect(direct) msymbol(D) mfcolor(magenta) mcolor(magenta) lcolor(magenta) lpattern(solid) ) ///		   
		,  ///
	ytitle("") subtitle("Panel C: Share of population aged 55 and over") xtitle("")  ylabel(18(2)26) ///
	legend(off) ///
	saving(fig3.gph, replace)
		

*-------------------------------------------------------------------
*							WVS
*-------------------------------------------------------------------
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013"
use "ZA4804_v2-0-0.dta", clear

desc a005 a003 a030 c037 c038 c039 c041 a165  a168a f114 a029 e035 e036 e037 e039


rename s009 country
replace country =  "UK" if country== "GB-GBN"
replace country =  "UK" if country== "GB-NIR"
replace country =  "EL" if country== "GR"

gen insample=0
foreach country in "AT" "BE" "CH" "DE" "DK" "EL" "ES" "FI" "FR" "IT" "NL" "PT" "SE" "UK" "US" "CA" {
	quietly replace insample= 1 if country=="`country'"
}
keep if insample==1

rename s020 year

keep country year ///
	s017 /// weights
	a005 a003 a030 c037 c038 c039 c041 ///
	a165  a168a f114 ///
	a029 e035 e036 e037 e039

compress

gen EVS=1
tab country year
save step2141_WVS_core, replace


**** US & CA
use wvs1981_2008_v20090914.dta, clear 

gen country=""

replace country="US" if s003==840
replace country="CA" if s003==124

keep if country~=""


rename s020 year

keep country year ///
	s017  /// weights
	a005 a003 a030 c037 c038 c039 c041 ///
	a165  a168a f114 ///
	a029 e035 e036 e037 e039
gen EVS=0
tab country year	
append using step2141_WVS_core

compress
tab country year
save step2141_WVS_core, replace	

	
egen cid=group(country)
egen yid=group(year)



	
*=======================================================
*			construct index
*=======================================================
gen WVS_index_1 = a005/.263 - a003/.202 + a030/.203 + c037/.423 + c038/.382 + c039/.282 + c041/.423
label var WVS_index_1     "WVS: Work ethic"

gen WVS_index_2 = -(a165/.196 - a168a/1.071 + f114/1.212)
label var WVS_index_2     "WVS: Trust"

gen WVS_index_3 = a029/0.17518 + e035/1.011 - e036/.696 -e039/0.754 - e037/.912531
label var WVS_index_3     "WVS: Individualism"

*===============================================================
*					plot time series
*===============================================================
gen ones=1	

collapse (mean) ///
	a005 a003 a030 c037 c038 c039 c041 ///
	a165  a168a f114 ///
	a029 e035 e036 e037 e039 ///
	(sd) ///
	a005_sd = a005 a003_sd = a003 a030_sd = a030 c037_sd = c037 c038_sd = c038 c039_sd = c039 c041_sd = c041 ///
	a165_sd = a165  a168a_sd = a168a f114_sd = f114 ///
	a029_sd = a029 e035_sd = e035 e036_sd = e036 e037_sd = e037 e039_sd = e039 ///	
	(min) ///
	a005_min = a005 a003_min = a003 a030_min = a030 c037_min = c037 c038_min = c038 c039_min = c039 c041_min = c041 ///
	a165_min = a165  a168a_min = a168a f114_min = f114 ///
	a029_min = a029 e035_min = e035 e036_min = e036 e037_min = e037 e039_min = e039 ///	
	(max) ///
	a005_max = a005 a003_max = a003 a030_max = a030 c037_max = c037 c038_max = c038 c039_max = c039 c041_max = c041 ///
	a165_max = a165  a168a_max = a168a f114_max = f114 ///
	a029_max = a029 e035_max = e035 e036_max = e036 e037_max = e037 e039_max = e039 ///		
	(count) Nobs = ones [aw=s017], by(country year)

save step2141_WVS_core2, replace

*** plot figures
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\figures"


twoway (line f114 year if country=="US", lcolor(black) lwidth(vthick)) ///
	   (line f114 year if country=="UK", lcolor(red) lpattern(longdash)) ///
	   (line f114 year if country=="FR", lcolor(blue) lpattern(dash)) ///
	   (line f114 year if country=="IT", lcolor(green) lpattern(shortdash)) ///
	   (scatter f114 year if country=="SE", connect(direct) msymbol(O) mfcolor(white) mcolor(red) lcolor(red) lpattern(solid) ) ///	  
	   (scatter f114 year if country=="DE", connect(direct) msymbol(S) mfcolor(blue) mcolor(blue) lcolor(blue) lpattern(solid) ) ///	      
	   (scatter f114 year if country=="ES", connect(direct) msymbol(D) mfcolor(magenta) mcolor(magenta) lcolor(magenta) lpattern(solid) ) ///		   
		,  ///
	ytitle("") subtitle("Panel D: Claim gov't benefits to which you are not entitled") xtitle("")  ///
	legend(off) ///
	saving(fig4.gph, replace)

gen a165A=1-a165/2	
twoway (line a165A year if country=="US", lcolor(black) lwidth(vthick)) ///
	   (line a165A year if country=="UK", lcolor(red) lpattern(longdash)) ///
	   (line a165A year if country=="FR", lcolor(blue) lpattern(dash)) ///
	   (line a165A year if country=="IT", lcolor(green) lpattern(shortdash)) ///
	   (scatter a165A year if country=="SE", connect(direct) msymbol(O) mfcolor(white) mcolor(red) lcolor(red) lpattern(solid) ) ///	  
	   (scatter a165A year if country=="DE", connect(direct) msymbol(S) mfcolor(blue) mcolor(blue) lcolor(blue) lpattern(solid) ) ///	      
	   (scatter a165A year if country=="ES", connect(direct) msymbol(D) mfcolor(magenta) mcolor(magenta) lcolor(magenta) lpattern(solid) ) ///		   
		,  ///
	ytitle("") subtitle("Panel E: Most people can be trusted") xtitle("")  ///
	legend(off) ///
	saving(fig5.gph, replace)
	
*=================================================
twoway (line f114 year if country=="US" & year<0, lcolor(black) lwidth(vthick)) ///
	   (line f114 year if country=="UK" & year<0, lcolor(red) lpattern(longdash)) ///
	   (line f114 year if country=="FR" & year<0, lcolor(blue) lpattern(dash)) ///
	   (line f114 year if country=="IT"  & year<0, lcolor(green) lpattern(shortdash)) ///
	   (scatter f114 year if country=="SE"  & year<0, connect(direct) msymbol(O) mfcolor(white) mcolor(red) lcolor(red) lpattern(solid) ) ///	  
	   (scatter f114 year if country=="DE"  & year<0, connect(direct) msymbol(S) mfcolor(blue) mcolor(blue) lcolor(blue) lpattern(solid) ) ///	      
	   (scatter f114 year if country=="ES"  & year<0, connect(direct) msymbol(D) mfcolor(magenta) mcolor(magenta) lcolor(magenta) lpattern(solid) ) ///		   
	   (scatter f114 year if country=="US" & year<0, connect(direct) msymbol(O) mfcolor(black) mcolor(white) lcolor(black) lpattern(dash) ) ///
		,  ///
		xtitle(" ") title(" ") ytitle("") ///
					legend(ring(0) pos(0) ///
						label(1 "US (Census/ACS/WVS)") label(2 "UK ('70 in Panels A, B, C)") label(3 "FR ('70 in Panels A, B, C)") label(4 "IT ('70 in Panels A, B, C)") ///
						label(5 "SE ('70 in Panels A, B, C)") label(6 "DE ('70 in Panels A, B, C)") label(7 "ES ('70 in Panels A, B, C)")  label(8 "US (CPS)") ///
						rows(8))  ///
						///
					yscale(off) xscale(off) ///
					plotregion( ifcolor(none) fcolor(none) lcolor(none)  ilcolor(none) ) ///
					graphregion( ifcolor(none) fcolor(none)  lcolor(none)  ilcolor(none) ) ///
					saving(fig_dummy.gph, replace)
	

	
graph combine fig1.gph	fig2.gph  fig3.gph fig4.gph fig5.gph fig_dummy.gph, imargin(tiny) rows(3)
		
				
					
log close
